
# Introduction -----

#In this script we will produce additional analyses as requested by the eLife reviewers

# Set up ----

#Load packages

pacman::p_load(tidyverse,patchwork,ghibli,
               lubridate,hms,gtsummary,
               lme4, lmerTest, broom.mixed)

#Get our default settings
source("./eLife Submission Scripts/Analysis-Common-Utilities.R")


# Artefact Removal =======


#There are two routes by which epochs are removed:

# - Those epochs flagged as artefactual by manual review during sleep scoring
# - Those epochs flagged as artefactual using the automated, iterative process using the Buckelmuller and recursive application of
#   Hjorth parameters

# Here, we will do some exploratory stats on whether the amount of artefact removal differs

# Load the artefact-removal data

#By-stage data
d_by_stage <- 
  readr::read_rds("./eLife Submission Data/sleep_study_epoch_removal.rds")


#Light wrangling
d_by_stage = 
  d_by_stage |>
  pivot_longer(n2:n3,names_to = "stage",values_to = "values") |>
  mutate(key = factor(key,levels = c('Total Post AR Epochs',
                                     'Proportion Total Epochs',
                                     'Proportion Post AR Epochs',
                                     'Proportion Same Epochs')))


#Filter only the values we want
d_art = 
  d_by_stage |>
  filter(key %in% c("Proportion Total Epochs", "Proportion Same Epochs")) |>
  left_join(meta |> select(subject,fsiqall, age_eeg, gender, family,
                           percnightn2_eeg, percnightn3_eeg), by = "subject")


# d_art |>
#   ggplot(aes(values)) +
#   geom_histogram(binwidth = 0.05) +
#   facet_grid(group ~ stage + key)

m_n2 = 
  d_art |>
  filter(stage == "n2") %>%
  group_by(key) %>%
  nest() %>%
  mutate(model = map(data, ~lmer(data = .x,
                                 formula = values ~ group + age_eeg + gender + percnightn2_eeg + (1|family)))) %>%
  mutate(tab = map(model,broom::tidy)) %>%
  unnest(tab) %>%
  select(key,term,estimate,std.error,statistic,df,p.value)


m_n3 = 
  d_art |>
  filter(stage == "n3") %>%
  group_by(key) %>%
  nest() %>%
  mutate(model = map(data, ~lmer(data = .x,
                                 formula = values ~ group + age_eeg + gender + percnightn3_eeg + (1|family)))) %>%
  mutate(tab = map(model,broom::tidy)) %>%
  unnest(tab) %>%
  select(key,term,estimate,std.error,statistic,df,p.value)

#So if we model the proportion of epochs removed, with the proportion of epochs of that stage included,
#plus age, sex, genotype and family as a random intercept, we do not see a significant effect of 
#genotype on the amount of epochs removed